﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Azyobuzi.りすにんぐついったー.Properties;
using Azyobuzi.りすにんぐついったー;
using System.Net;
using System.Xml;
using System.IO;
using System.Text.RegularExpressions;

namespace Azyobuzi.りすにんぐついったー
{
    public partial class MainForm : Form
    {
        bool isExit = false;
        bool over = false;
        string oldData = "";

        public MainForm()
        {
            InitializeComponent();

            this.Icon = Resources.mainIco;
            notifyIcon1.Icon = Resources.mainIco;
        }

        uint interval;
        MsnCommandListener msn = new MsnCommandListener();

        private void OneSecTimer_Tick(object sender, EventArgs e)
        {
            interval -= 1;
            var m = interval / 60;
            var s = interval % 60;
            timeLbl.Text = string.Format("{0}分{1}秒後に投稿されます", m, s);

            if (interval == 0)
            {
                PostTweet(true);
                interval = SettingsXml.Instance.interval;
            }
        }

        /// <returns>投稿処理まで実行できた場合はtrue、それ以外はfalseを返します。</returns>
        internal bool PostTweet(bool auto)
        {
            bool re = false;
            var tweet = tweetBox.Text;

            if (!(this.Visible && tweetBox.Focused) && tweet != oldData && !string.IsNullOrEmpty(tweet.Trim()))
            {
                OneSecTimer.Stop();
                timeLbl.Text = "Sending...";

                var li = new LogItem()
                {
                    Tweet = tweet,
                    Auto = auto
                };

                var content = "";
                string statusId;
                HttpStatusCode hsc=Program.twitterConnection.UpdateStatus(tweet, ref content);
                if (hsc == HttpStatusCode.OK && tryGetStatusIdFromXml(content, out statusId))
                {
                    li.TweetID = statusId;
                    oldData = tweet;
                    notifyIcon1.ShowBalloonTip(0, "投稿しました", tweet, ToolTipIcon.Info);
                    re = true;
                    postBtn.Enabled = false;
                    今すぐ投稿NToolStripMenuItem.Enabled = false;
                    li.Success = true;
                    li.DeleteBtn = true;
                }
                else
                {
                    notifyIcon1.ShowBalloonTip(0, "投稿に失敗しました", hsc.ToString(), ToolTipIcon.Error);
                    re = true;
                }

                li.Date = DateTime.Now;

                //LogSettingsManager.Log.Add(li);
                //LogSettingsManager.Save();
                LogSettingsManager.AddLog(li);

                timeLbl.Text = "";
                interval = SettingsXml.Instance.interval;
                if (SettingsXml.Instance.auto) { OneSecTimer.Start(); }
            }

            return re;
        }

        private bool tryGetStatusIdFromXml(string xml, out string statusId)
        {
            XmlDocument xmlDoc = new XmlDocument();
            try
            {
                xmlDoc.LoadXml(xml);
            }
            catch (XmlException)
            {
                statusId = "";
                return false;
            }
            XmlNode node = xmlDoc.SelectSingleNode("/status/id");
            if (node == null)
            {
                statusId = "";
                return false;
            }
            else
            {
                statusId = node.InnerText;
                return true;
            }
        }

        private void msn_ReceiveMsnCommand(MsnCommandListener.ReceiveMsnCommandEventArgs e)
        {
            this.Invoke((MethodInvoker)delegate
            {
                string re;
                //re = SettingsXml.Instance.template.Replace("%0", e.Datas[0]).Replace("%1", e.Datas[1]);
                re = string.Format(SettingsXml.Instance.template, e.Datas);
                if (e.Datas[0].Trim().Length == 0 || e.Datas[1].Trim().Length == 0)
                {
                    re = "";
                    postBtn.Enabled = false;
                    今すぐ投稿NToolStripMenuItem.Enabled = false;
                }
                else
                {
                    postBtn.Enabled = true;
                    今すぐ投稿NToolStripMenuItem.Enabled = true;
                }

                tweetBox.Text = re;
            });
        }

        internal Version GetVersion()
        {
            System.Reflection.Assembly asm = System.Reflection.Assembly.GetExecutingAssembly();
            return asm.GetName().Version;
        }

        private void MainForm_Shown(object sender, EventArgs e)
        {
            this.Visible = false;

            //バージョンチェック
            Version netver = null;
            using (var wc = new WebClient()) 
            {
                try 
                {
                    netver = new Version(wc.DownloadString("http://listwi.sourceforge.jp/version.txt"));
                } catch (WebException) { }
            }
            if (netver != null && netver > GetVersion() && MessageBox.Show("最新版 "+ netver.ToString() + 
                " がリリースされています。ダウンロードしますか？","りすにんぐついったー",
                MessageBoxButtons.YesNo,MessageBoxIcon.Information) == DialogResult.Yes)
            {
                System.Diagnostics.Process.Start("http://sourceforge.jp/projects/listwi/releases/");
            }

            //初期化
            var s = SettingsXml.Instance;
            if (string.IsNullOrEmpty(s.accessToken) || string.IsNullOrEmpty(s.accessTokenSecret))
            {
                auth();
            }
            else
            {
                Program.twitterConnection.Initialize("GmeOXd6M3zE89zKqsJwjw", "Wq9lBb5VpW4To5QLi4lFc5sb2ne5tiCxyS6iHmWFG6s", s.accessToken, s.accessTokenSecret, "");
            }

            notifyIcon1.Visible = true;

            

            var myname = Program.twitterConnection.GetMyScreenName();
            if (myname == null)
            {
                notifyIcon1.Visible = false;
                auth();
                notifyIcon1.Visible = true;
                myname = Program.twitterConnection.GetMyScreenName();
            }

            notifyIcon1.ShowBalloonTip(0, "", "@" + myname + " さん、ようこそ", ToolTipIcon.None);

            //投稿内容が旧書式でないか確認
            if (Regex.IsMatch(s.template, @"\%\d")) MessageBox.Show("投稿内容が古いバージョンの書式です。変更してください。", "互換性の問題", MessageBoxButtons.OK, MessageBoxIcon.Warning);

            msn.ReceiveMsnCommand += msn_ReceiveMsnCommand;
            msn.Start();

            interval = s.interval;
            if (s.auto) { OneSecTimer.Start(); }
        }

        private void auth()
        {
            MessageBox.Show("Twitter認証を行います。", "Twitter認証", MessageBoxButtons.OK, MessageBoxIcon.Information);
            var f = new AuthForm();
            if (f.ShowDialog(this) == DialogResult.Cancel)
            {
                isExit = true;
                this.Close();
            }
        }

        private void 終了XToolStripMenuItem_Click(object sender, EventArgs e)
        {
            isExit = true;
            this.Close();
        }

        private void MainForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (e.CloseReason == CloseReason.UserClosing && !isExit)
            {
                e.Cancel = true;
                this.Visible = false;
            }
            else
            {
                try { msn.Stop(); msn.Dispose(); }
                catch { /*何もしない*/ }

                //設定保存
                SettingsXml.Instance.bouds = this.Bounds;
                SettingsXml.Save();
                LogSettingsManager.Save();
            }
        }

        private void tweetBox_Enter(object sender, EventArgs e)
        {
            if (!over)
            {
                tweetBox.BackColor = SystemColors.Info;
            }
        }

        private void tweetBox_Leave(object sender, EventArgs e)
        {
            if (!over)
            {
                tweetBox.BackColor = SystemColors.Window;
            }
        }

        private void tweetBox_TextChanged(object sender, EventArgs e)
        {
            charcount.Text = "残り" + (140 - tweetBox.TextLength) + "文字";

            if (tweetBox.TextLength > 140)
            {
                over = true;
            }
            else
            {
                over = false;
            }
            TweetBoxBackColor();

            postBtn.Enabled = tweetBox.TextLength != 0 && tweetBox.Text != oldData;
        }

        public void TweetBoxBackColor()
        {
            if (over)
            {
                tweetBox.BackColor = Color.Red;
            }
            else if (tweetBox.Focused)
            {
                tweetBox_Enter(tweetBox, new EventArgs());
            }
            else
            {
                tweetBox_Leave(tweetBox, new EventArgs());
            }
        }

        private void 設定SToolStripMenuItem_Click(object sender, EventArgs e)
        {
            var settings = new SettingsForm();
            settings.Show(this);
        }

        private void MainForm_Load(object sender, EventArgs e)
        {
            var s = SettingsXml.Instance;
            this.Bounds = s.bouds;
            自動投稿PToolStripMenuItem.Checked = s.auto;
        }

        private void postBtn_Click(object sender, EventArgs e)
        {
            PostTweet(false);
        }

        private void 自動投稿PToolStripMenuItem_CheckedChanged(object sender, EventArgs e)
        {
            var c = 自動投稿PToolStripMenuItem.Checked;
            SettingsXml.Instance.auto = c;

            if (c)
            {
                OneSecTimer.Start();
            }
            else
            {
                OneSecTimer.Stop();
                timeLbl.Text = "";
                interval = SettingsXml.Instance.interval;
            }
        }

        private void メイン画面を表示VToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.Visible = true;
        }

        private void MainForm_Deactivate(object sender, EventArgs e)
        {
            tweetBox_Leave(tweetBox, new EventArgs());
        }

        private void MainForm_Activated(object sender, EventArgs e)
        {
            TweetBoxBackColor();
        }

        private void つぶやきログLToolStripMenuItem_Click(object sender, EventArgs e)
        {
            LogForm.ShowForm();
        }

        private void listeningMessenderMToolStripMenuItem_Click(object sender, EventArgs e)
        {
            ListeningMessender.ShowForm();
        }

        private void wikiToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Program.ShowWiki("FrontPage");
        }

        private void バージョン情報AToolStripMenuItem_Click(object sender, EventArgs e)
        {
            MessageBox.Show(string.Format("りすにんぐついったー\n\nVersion {0}", GetVersion()), "りすにんぐついったー", MessageBoxButtons.OK, MessageBoxIcon.Information);
        }

        private void notifyIcon1_MouseClick(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Left)
            {
                this.Visible = true;
                this.Activate();
            }
        }
    }
}
